<script>
    $(document).ready(function() {
        var $scopeWidgetFilter = $('#widget-filter');
//        $('.selectpicker', $scopeWidgetFilter).selectpicker();
        $('.selectpicker', $scopeWidgetFilter).selectpicker({style: 'btn-sm'});

        $('.datepicker-range', $scopeWidgetFilter).datepicker({
            language: "ru",
            autoclose: true,
            todayHighlight: true,
            format: "yyyy/mm/dd"
        });
        
        // http://stackoverflow.com/questions/24981072/bootstrap-datepicker-empties-field-after-selecting-current-date
        $('.datepicker-range :input', $scopeWidgetFilter).each(function() {
            if ('' != $(this).val()) {
                $(this).one('show', function(e) {
                    if ( e.date ) {
                         $(this).data('stickyDate', e.date);
                    } else {
                         $(this).data('stickyDate', null);
                    }
                });
                $(this).one('hide', function(e){
                    var stickyDate = $(this).data('stickyDate');

                    if ( !e.date && stickyDate ) {
                        $(this).datepicker('setDate', stickyDate);
                        $(this).data('stickyDate', null);
                    }
                });
            }
        });

        // Find client logposts by client ID
        $('#client_filter_btn').on('click', function(){
            $('#client_filter_alert').css('display', 'none');
            if($('#client_filter').val() != ''){
                $.ajax({
                    url: "/worker/check/isset_client",
                    type: "POST",
                    data: {'client_id': $('#client_filter').val()},
                    dataType: 'json',
                })
                .done(function(data){
                    if(data.find){
                        // TODO: $.ajax with async: false causes new window to be block by browser
                        var win = window.open(data.url, '_blank');
                        win.focus();
                    }else{
                        $('#client_filter_alert').text('ClientID not finded!')
                        $('#client_filter_alert').css('display', 'block');
                    }
                })
                .fail(function() {
                    $('#client_filter_alert').text('ClientID not finded!')
                    $('#client_filter_alert').css('display', 'block');
                });
            }else{
                $('#client_filter_alert').text('ClientID is empty!')
                $('#client_filter_alert').css('display', 'block');
            }
        });
        $('#client_filter').on('keydown', function(e) {
            if (e.keyCode == 13) {
                $('#client_filter_btn').triggerHandler('click');
            }
        });
        
        // Handling user query selection
        var $inputUserQuery = $(':input[name="user_query"]', $scopeWidgetFilter);
        var ajaxUserQuery = null;
        $inputUserQuery.on('change', function() {
            var user_query = $inputUserQuery.val();
            if ('0' == user_query) {
                return;
            }
            
            if (ajaxUserQuery) {
                ajaxUserQuery.abort();
            }
            
            ajaxUserQuery = $.ajax({
                method: 'GET',
                url: '/logpost/user_query',
                data: {
                    'user_query': user_query
                },
                dataType: 'JSON'
            })
            .done(function(user_query) {
                $.each(user_query, function(name, val){
                    var $input = $(':input[name="'+name+'"]');
                    var type = $input.attr('type');

                    switch(type) {
                        case 'checkbox':
                            $input.prop('checked', val);
                            break;
                        case 'radio':
                            $input.filter('[value="' + val + '"]').prop('checked', true);
                            break;
                        default:
                            $input.val(val);
                            break;
                    }
                });
            })
            .always(function() {
                ajaxUserQuery = null;
            });
        });

        // If user make modification to filters reset user query select,
        // so on server side it will use filters instead of user query
        $(':input', $scopeWidgetFilter).not($inputUserQuery).not('[name="cpp"]').on('input propertychange change', function() {
            $inputUserQuery.selectpicker('val', '0');
        });
        
        // Make user_query_name required in modal, we can not do this in HTML, because
        // browser blocks submiting form which have hidden+required inputs
        $('#modal-save-to-my-queries').on('show.bs.modal', function() {
            $('input[name="user_query_name"]', $(this)).attr('required', 'required');
        }).on('hide.bs.modal', function() {
            $('input[name="user_query_name"]', $(this)).removeAttr('required');
        });
    });
</script>